//Created: May 11, 2007
//Revised: September 18, 2008

#include "Methods.h"
#include "Vector.cpp"
#include <iostream>

using namespace std;

int isDigit(char c) {
	// return whether or not the char Ascii value is between the Ascii values of 0 and 9
	return c >= '0' && c <= '9';
}

void clearBuffer(char c) {
	// loop through the data in the buffer until a newline char is encountered
	while(c != '\n') {
		scanf_s("%c", &c);
	}
}

int inputInteger(void) {
	// variable declaration
	char c;
	int value = 0;

	// read integer from buffer (start reading if buffer is empty) and run a loop until char is a CR
	scanf_s("%c", &c);
	while(c != '\n') {

		// append the integer to the value
		if(isDigit(c)) {
			value = ( value * 10 ) + (c - '0');
		}

		// if an illegal character is encountered, clear the buffer and return -1
		else {
			clearBuffer(c);
			return -1;
		}
		
		// read the next char
		scanf_s("%c", &c);
		
	}
	
	return value;
}

void trim(char * str) {
	int start, end, i, j, str_len=(int)strlen(str);
	
	if(str == NULL)
		return;
	
	start = 0;
	while(start < str_len && (str[start] == ' ' || str[start] == '\t') ) {
		start++;
	}
	
	end = str_len - 1;
	while(end >= 0 && (str[end] == ' ' || str[end] == '\t') ) {
		end--;
	}
	
	if(end <= start) {
		str[0] = '\0';
	}
	else if(start != 0 || end != str_len - 1) {
		j = 0;
		for(i=start;i<=end;i++) {
			str[j++] = str[i];
		}
		str[j] = '\0';
	}
}

char * trimCopy(const char * str) {
	if(str == NULL) { return NULL; }
	
	char * str2 = new char[strlen(str)+1];
	strcpy(str2, str);
	trim(str2);

	return str2;
}

void append(char str1[COMMAND_LENGTH], const char * str2) {
	int i,j=(int)strlen(str1);
	for(i=0;i<(int)strlen(str2);i++) {
		if(j<COMMAND_LENGTH) {
			str1[j++] = str2[i];
		}
	}
	if(j<COMMAND_LENGTH-1) {
		str1[j] = '\0';
	}
}

char * strsub(const char * str, int start, int end) {
	char * sub = NULL;
	if(str == NULL || strlen(str) == 0) {
		sub = new char[1];
		sub[0] = '\0';
		return sub;
	}
	if(start < 0) { start = 0; }
	if(end > (int)(strlen(str))-1) { end = (int)(strlen(str))-1; }
	
	int j=0;
	
	sub = new char[end-start+2];

	for(int i=start;i<=end;i++) {
		sub[j++] = str[i];
	}
	
	sub[j] = '\0';
	
	return sub;
}

Vector<Mod> * readMods(const char * fileName, const char * category) {
	Vector<Mod> * mods = new Vector<Mod>;
	
	if(fileName == NULL || strlen(fileName) == 0) { return mods; }
	
	Vector<Variable> * variables = new Vector<Variable>;
	
	bool foundCategory = false;
	bool foundNextCategory = false;
	char input[MAX_LENGTH];
	Variable * var = NULL;
	Mod * mod = NULL;
	char * cat = NULL;
	char * mod_name;
	char * mod_type;
	char * mod_con;
	char * mod_group;
	
	ifstream fpt(fileName);
	while(fpt != NULL && !fpt.eof() && !foundNextCategory) {
		fpt.getline(input, MAX_LENGTH);
		
		if(!isComment(input)) {
			
			var = parseVariable(input);
			cat = parseCategory(input);
			
			if(foundCategory) {
				if(var != NULL) {
					variables->add(*var);
					var = NULL; // prevent deletion of the object
				}
				else if(cat != NULL) {
					foundNextCategory = true;
				}

				if(strlen(input) == 0 && variables->size() > 0) {
					mod_name = getVariableValue("Name", variables);
					mod_type = getVariableValue("Type", variables);
					mod_con = getVariableValue("Con", variables);
					mod_group = getVariableValue("Group", variables);
					
					if(mod_name == NULL || mod_type == NULL || mod_group == NULL) {
						cout << "ERROR: Invalid mod detected.";
						if(mod_name != NULL) {
							cout << " Name of mod: \"" << mod_name << "\"";
						}
						cout << endl;
					} else {
						if(mod_con == NULL) {
							mod = new Mod(mod_name, mod_type, "", mod_group);
						} else if(mod_group == NULL) {
							mod = new Mod(mod_name, mod_type, mod_con, "");
						} else {
							mod = new Mod(mod_name, mod_type, mod_con, mod_group);
						}
						mods->add(*mod);
					}

					for(int j=0;j<variables->size();j++) {
						delete &(variables->elementAt(j));
					}
					variables->clear();
				}
			}
			
			if(cat != NULL && strcasecmp(cat, category) == 0) { foundCategory = true; }
			
			if(var != NULL) { delete var; }
			if(cat != NULL) { delete [] cat; }
		}
	}
	
	if(fpt != NULL) { fpt.close(); }

	if(variables != NULL) { delete variables; }

	return mods;
}

Vector<Variable> * readVariables(const char * fileName, const char * category, bool allowDuplicates) {
	Vector<Variable> * v = new Vector<Variable>;
	if(fileName == NULL || strlen(fileName) == 0) { return v; }
	bool hasCategory = (category == NULL || strlen(category) == 0) == 0;
	bool foundCategory = !hasCategory;
	bool foundNextCategory = false;
	char input[MAX_LENGTH];
	Variable * var = NULL;
	char * cat = NULL; 
	
	ifstream fpt(fileName);
	while(fpt != NULL && !fpt.eof() && !foundNextCategory) {
		fpt.getline(input, MAX_LENGTH);
		
		if(!isComment(input)) {
			
			var = parseVariable(input);
			cat = parseCategory(input);
			
			if(foundCategory) {
				if(var != NULL) {
					if( !(!allowDuplicates && v->contains(*var)) ) {
						v->add(*var);
						var = NULL; // prevent deletion of the object
					}
				}
				else if(cat != NULL) {
					if(hasCategory) {
						foundNextCategory = true;
					}
				}
			}
			
			if(cat != NULL && strcasecmp(cat, category) == 0) { foundCategory = true; }
			
			if(var != NULL) { delete var; }
			if(cat != NULL) { delete [] cat; }
		}
	}
	
	if(fpt != NULL) { fpt.close(); }
	
	return v;
}

bool isComment(const char * data) {
	if(data == NULL || strlen(data) < 2) { return false; }
	
	char * str = trimCopy(data);
	
	bool comment = (str[0] == '/' && str[1] == '/');

	if(str != NULL) { delete [] str; }

	return comment;
}

char * parseCategory(const char * data) {
	if(data == NULL || strlen(data) < 3) { return NULL; }

	char * category = NULL;

	char * str = trimCopy(data);
	char * str2;
	
	if(str[0] != '[' || str[strlen(str)-1] != ']') { return NULL; }
	
	str2 = strsub(str, 1, (int) strlen(str) - 2);
	category = trimCopy(str2);
	
	if(str != NULL) { delete [] str; }
	if(str2 != NULL) { delete [] str2; }

	return category;
}

Variable * parseVariable(const char * data) {
	if(data == NULL || strlen(data) < 3) { return NULL; }
	
	char * str = trimCopy(data);

	int separatorIndex = -1;
	Variable * v = NULL;
	char * str2 = NULL;
	char * str3 = NULL;
	char * id = NULL;
	char * value = NULL;
	
	for(int i=0;i<(int)strlen(str);i++) {
		if(str[i] == ':') {
			separatorIndex = i;
			break;
		}
	}
	
	if(separatorIndex == -1) { return NULL; }
	
	str2 = strsub(str, 0, separatorIndex-1);
	if(separatorIndex == ((int)strlen(str))-1) {
		str3 = new char[1];
		str3[0] = '\0';
	} else {
		str3 = strsub(str, separatorIndex+1, (int) (strlen(str)-1));
	}
	
	id = trimCopy(str2);
	value = trimCopy(str3);
	
	v = new Variable(id, value);
	
	if(id != NULL) { delete [] id; }
	if(value != NULL) { delete [] value; }
	if(str3 != NULL) { delete [] str3; }
	if(str2 != NULL) { delete [] str2; }
	if(str != NULL) { delete [] str; }
	
	return v;
}

char * getVariableValue(const char * id, const Vector<Variable> * v) {
	if((id == NULL || strlen(id) == 0) ||
		(v == NULL || v->size() == 0)) return NULL;
	
	for(int i=0;i<v->size();i++) {
		if( strcasecmp(id, v->elementAt(i).id()) == 0 ) {
			return v->elementAt(i).value();
		}
	}
	
	return NULL;
}
